unit CompRect;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tRectangle = class(tDrawComponent)
  private
  public
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    function GetRgn: hRgn; override;
    procedure OnMakePolyline(Sender: TObject);
    procedure Paint; override;
    procedure SetPropList; override;
  end;

var dciRectangle: Integer;

implementation

uses Dialogs, SysUtils,
     CompPolyline;

constructor tRectangle.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 12;
  inherited CreateByBasicName(aOwner, 'Rectangle');
  Color:= clMoneyGreen;
  CreatingByAddPoint:= True;
end;

constructor tRectangle.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

function tRectangle.GetRgn: hRgn;
begin
    Result:= CreateRectRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
end;

procedure tRectangle.OnMakePolyline(Sender: TObject);
var PP: tPolyline;
    i: Integer;
begin
  PP:= tPolyline.CreateBy(Owner);
  PP.AddPoint(Point(Left, Top));
  PP.AddPoint(Point(Left+ Width, Top));
  PP.AddPoint(Point(Left+ Width, Top+ Height));
  PP.AddPoint(Point(Left, Top+ Height));
  PP.Closed:= True;
  PP.Update;
  for i:= 0 to ComponentCount- 1 do
    tDrawComponent(Components[0]).ChangeOwner(PP);
  Delete;
  DrawFace.Invalidate;
end;

procedure tRectangle.Paint;
begin
  with DrawFace.Canvas do
  begin
    Brush.Color:= Color;
    Brush.Style:= bsSolid;
    Pen.Width:= Round(DrawFace.ZoomFactor* LineWidth);
    if Pen.Width< 1 then Pen.Width:= 1;
    if DrawFace.Printing then Pen.Color:= clBlack
                          else Pen.Color:= LineColor;
    Rectangle(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top * DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
  end;
  inherited;
end;

procedure tRectangle.SetPropList;
begin
  inherited;
  with PropList do
  begin
    Add(tMenuProp.CreateProp(OnMakePolyline, 'Convert to polyline'));
  end;
end;

initialization

  //dci -> DrawComponentIndex

  dciRectangle:= DrawCompItemList.Add(tDrawCompItem.Create('Rectangle', tRectangle));

end.
